binWidth=1; fr='1s'; % binWidth = framerate
combinedLifetimes = combinedLifetimes(combinedLifetimes>=binWidth*5);
tlow = min(combinedLifetimes); thigh = max(combinedLifetimes);

N_init = 10;

n_subpop = 3; 


k_fixed = [1,3,5,7,9,11,13]; 

for i=1:numel(n_subpop)
    i;
    shapes_fixed=unique(sort(nchoosek(ones(1,n_subpop(i)),n_subpop(i)),2), 'rows');
    
    [probs_control, scales_control, shapes_control, f_best_control, init_best_control] = fitting_trun(binWidth, combinedLifetimes, n_subpop, 'pdf', [tlow,thigh], 1, shapes_fixed, N_init);
   
    [scales_control,I] = sort(scales_control);
    probs_control = probs_control(I);
    shapes_control = shapes_control(I);

    meanLifetimes_control = scales_control.*gamma(1+1./shapes_control);

    binCtrs = tlow:binWidth:thigh;
    rawHisto = histcounts(combinedLifetimes,[binCtrs thigh+binWidth]);
    nu = size(combinedLifetimes,1);
    normHisto = rawHisto/(nu*binWidth);

    %%
    figure()
    plot(binCtrs, normHisto, 'k-.','LineWidth',4)
    hold on
    if n_subpop(i)==1
        f = @(x,a,b) wblpdf(x,a,b)/(wblcdf(thigh,a,b)-wblcdf(tlow,a,b));
        f_curr = f(binCtrs, scales_control(1), shapes_control(1));
    elseif n_subpop(i)==2
        f = @(x,p,a,b,c,d) p*wblpdf(x,a,b)/(wblcdf(thigh,a,b)-wblcdf(tlow,a,b)) + (1-p)*wblpdf(x,c,d)/(wblcdf(thigh,c,d)-wblcdf(tlow,c,d));
        f_curr = f(binCtrs, probs_control(1),  scales_control(1), shapes_control(1), scales_control(2), shapes_control(2));
    elseif n_subpop(i)==3
        f = @(x,p,q,a,b,c,d,e,f) p*wblpdf(x,a,b)/(wblcdf(thigh,a,b)-wblcdf(tlow,a,b)) + q*wblpdf(x,c,d)/(wblcdf(thigh,c,d)-wblcdf(tlow,c,d)) + (1-p-q)*wblpdf(x,e,f)/(wblcdf(thigh,e,f)-wblcdf(tlow,e,f));
        f_curr = f(binCtrs, probs_control(1), probs_control(2), scales_control(1), shapes_control(1), scales_control(2), shapes_control(2), scales_control(3), shapes_control(3));
    elseif n_subpop(i)==4
        f = @(x,p,q,r,a,b,c,d,e,f,g,h) p*wblpdf(x,a,b)/(wblcdf(thigh,a,b)-wblcdf(tlow,a,b)) + q*wblpdf(x,c,d)/(wblcdf(thigh,c,d)-wblcdf(tlow,c,d)) + r*wblpdf(x,e,f)/(wblcdf(thigh,e,f)-wblcdf(tlow,e,f)) + (1-p-q-r)*wblpdf(x,g,h)/(wblcdf(thigh,g,h)-wblcdf(tlow,g,h));
        f_curr = f(binCtrs, probs_control(1), probs_control(2), probs_control(3), scales_control(1), shapes_control(1), scales_control(2), shapes_control(2), scales_control(3), shapes_control(3), scales_control(4), shapes_control(4));
    elseif n_subpop(i)==5
        f = @(x,p,q,r,s,a,b,c,d,e,f,g,h,i,j) p*wblpdf(x,a,b)/(wblcdf(thigh,a,b)-wblcdf(tlow,a,b)) + q*wblpdf(x,c,d)/(wblcdf(thigh,c,d)-wblcdf(tlow,c,d)) + r*wblpdf(x,e,f)/(wblcdf(thigh,e,f)-wblcdf(tlow,e,f)) + s*wblpdf(x,g,h)/(wblcdf(thigh,g,h)-wblcdf(tlow,g,h)) + (1-p-q-r-s)*wblpdf(x,i,j)/(wblcdf(thigh,i,j)-wblcdf(tlow,i,j));
        f_curr = f(binCtrs, probs_control(1), probs_control(2), probs_control(3), probs_control(4), scales_control(1), shapes_control(1), scales_control(2), shapes_control(2), scales_control(3), shapes_control(3), scales_control(4), shapes_control(4), scales_control(5), shapes_control(5));
    end
    plot(binCtrs, f_curr, 'color', [0.5,0.5,0.5],'LineWidth',2)
    ax=gca;
    lg = {'empirical','overall fit'};
    colors_list = [0.5,0,0; 0,0,0.5; 0,0.5,0; 0.5,0.5,0; 0,0.5,0.5; 0.25,0.25,0.25; 0.75,0.75,0.75];
    for j=1:n_subpop(i)
        plot(binCtrs, probs_control(j)*wblpdf(binCtrs,scales_control(j),shapes_control(j))/(wblcdf(thigh,scales_control(j),shapes_control(j))-wblcdf(tlow,scales_control(j),shapes_control(j))), 'color', colors_list(j,:),'LineWidth',2)
        lg = [lg strcat(num2str(round(shapes_control(j),2)),', ',num2str(round(meanLifetimes_control(j),2)),'s, ', num2str(round(probs_control(j)*100,2)),'%')];
    end

    ax.FontSize=15;
    ax.XLim = [0,100];
    xlabel('lifetime (s)')
    ylabel('probability density')
    legend(lg)
    title(strcat('RSS=',num2str(f_best_control)))

    RSS = f_best_control;
    n = numel(normHisto);
    k = k_fixed(i);

    BIC = n*log(RSS/n) + k*log(n);
    AIC = n*log(RSS) + 2*k;
    
    BIC_all(i) = BIC;
    AIC_all(i) = AIC;
    
    x = num2str(shapes_fixed);
    x = x(~isspace(x));
    xticklabels{i} = x;
end
clearvars
clc